<?php

namespace App\Http\Controllers\Api\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AppProfileController extends Controller
{

    public function index()
    {
        $employee = auth('employee')->user();
        return $this->apiResponse(data: [
            'name' => $employee->name,
            'section' => $employee->section?->name ?? __('messages.section_not_found'),
            'code' => $employee->code,
            'phone' => $employee->phone,
        ]);
    }
}
