<?php

namespace App\Http\Controllers\Api\Employee\Attendance;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\AttendanceMethod;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\AttendanceMethodResource;
use App\Http\Requests\Api\AttendanceMethod\StoreAttendanceMethodRequest;
use App\Http\Requests\Api\AttendanceMethod\UpdateAttendanceMethodRequest;

class AttendanceMethodController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view attendance methods');

        return $this->apiResponse(data: AttendanceMethodResource::collection(CompanyHelper::getCompany()->attendanceMethods));
    }

    public function show(AttendanceMethod $attendanceMethod)
    {
        $this->authorize('show attendance methods');

        return $this->apiResponse(data: AttendanceMethodResource::make($attendanceMethod));
    }

    public function store(StoreAttendanceMethodRequest $request)
    {
        $this->authorize('create attendance methods');

        return $this->apiResponse(
            message: __('messages.attendance_method_created_successfully'),
            data: AttendanceMethodResource::make(CompanyHelper::getCompany()->attendanceMethods()->create($request->validated()))
        );
    }

    public function update(UpdateAttendanceMethodRequest $request, AttendanceMethod $attendanceMethod)
    {
        $this->authorize('edit attendance methods');

        $attendanceMethod->update($request->validated());
        return $this->apiResponse(
            message: __('messages.attendance_method_updated_successfully'),
            data: AttendanceMethodResource::make($attendanceMethod)
        );;
    }

    public function destroy(AttendanceMethod $attendanceMethod)
    {
        $this->authorize('delete attendance methods');

        $attendanceMethod->delete();
        return $this->apiResponse(message: __('messages.attendance_method_deleted_successfully'));
    }
}
