<?php

namespace App\Http\Controllers\Api\Employee\Auth;

use App\Models\Worker;
use App\Trait\ApiTrait;
use App\Models\Employee;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Api\Employee\Auth\LoginRequest;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    use ApiTrait;

    public function login(LoginRequest $request)
    {
        $employee = Employee::where('code', $request->code)->first();
        if (!$employee || !Hash::check($request->password, $employee->password) || $employee->login_flag) {
            throw ValidationException::withMessages([
                'code' => [
                    'invalid code or password, please try again.',
                ]
            ]);
        }
        $employee->update([
            "fcm" => $request->fcm_token
        ]);

        // $employee->login_flag = true;
        $employee->save();
        $token = $employee->createToken('employee')->plainTextToken;
        // $employee->load('branch');
        return $this->apiResponse(
            data: [
                'employee_id' =>    $employee->id,
                'token' => $token,
            ],
            message: "Successfully Logged in."
        );
    }
    public function getEmployeeData()
    {
        $employee = auth('employee')->user();
        dd($employee);
    }


    public function logout(Request $request){
        $request->user()->currentAccessToken()->delete();
        return $this->apiResponse(message: "Logged out successfully.");
    }

    public function deleteAccount(){

            $employee = Employee::where('id', auth()->user()->id)->first();
            if (!$employee) {
                return $this->apiResponse(
                    message: "employee not exists"
                );
            }
            $employee->delete();

            return $this->apiResponse(
                message: "employee deleted successfully"
            );



    }
}
