<?php

namespace App\Http\Controllers\Api\Employee\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Employee\Auth\ChangeEmployeePasswordRequest;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class ChangePasswordController extends Controller
{
    use ApiTrait;

    public function update(ChangeEmployeePasswordRequest $request)
    {
        $user = $request->user('worker');

        if (!Hash::check($request->old_password, $user->employee->password)) {
            throw ValidationException::withMessages(['old_password' => __('messages.old_password_does_not_match')]);
        }

        $user->employee()->update([
            'password' => Hash::make($request->password),
        ]);

        $user->tokens()->delete();

        $token = $user->createToken('employee')->plainTextToken;

        return $this->apiResponse(message: __('auth.password_updated_successfully'), data: ['token' => $token]);
    }
}
