<?php

namespace App\Http\Controllers\Api\Employee\Career;

use App\Models\Career;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Employee\Career\StoreCareerRequest;
use App\Http\Requests\Api\Employee\Career\UpdateCareerRequest;
use App\Http\Resources\CareerSectionResource;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class CareerController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view careers');

        return $this->apiResponse(
            data: CareerSectionResource::collection(
                CompanyHelper::getCompany()->careers()->where('type', Career::CAREER_TYPE)->get()
            )
        );
    }

    public function show(Career $career)
    {
        $this->authorize('show careers');

        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }

        return $this->apiResponse(data: CareerSectionResource::make($career));
    }

    public function store(StoreCareerRequest $request)
    {
        $this->authorize('create careers');

        return $this->apiResponse(
            message: __('messages.career_created_successfully'),
            data: CareerSectionResource::make(
                CompanyHelper::getCompany()
                    ->careers()
                    ->create($request->validated())
            )
        );
    }

    public function update(UpdateCareerRequest $request, Career $career)
    {
        $this->authorize('edit careers');

        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        $career->update($request->all());
        $career = new CareerSectionResource($career);
        return $this->apiResponse(message: __('messages.career_updated_successfully'), data: $career);;
    }

    public function destroy(Career $career)
    {
        $this->authorize('delete careers');

        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        $career->delete();
        return $this->apiResponse(message: __('messages.career_deleted_successfully'));
    }
}
