<?php

namespace App\Http\Controllers\Api\Employee\Transaction;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\EmployeeTransaction;
use App\Http\Controllers\Controller;
use App\Http\Resources\EmployeeTransactionResource;
use App\Http\Requests\Api\Employee\Transaction\StoreTransactionRequest;

class EmployeeTransactionController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view employee transactions');

        $company = $request->user();
        $transaction = $company->employeeTransactions;
        $transaction =  EmployeeTransactionResource::collection($transaction);
        return $this->apiResponse(data: $transaction);
    }


    public function store(StoreTransactionRequest $request)
    {
        $this->authorize('create employee transactions');

        $company = $request->user();
        $transaction = $company->employeeTransactions()->create($request->validated());
        $transaction->employee()->update([
            'branch_id' => $transaction->to_branch_id
        ]);
        $transaction =  new EmployeeTransactionResource($transaction);
        return $this->apiResponse(data: $transaction);
    }
}
