<?php

namespace App\Http\Controllers\Api\Package;

use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateFeatureNameRequest;
use App\Http\Resources\FeatureResource;
use App\Models\Feature;
use App\Models\Package;

class FeatureController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: FeatureResource::collection(Feature::get()),
        );
    }
    public function update(UpdateFeatureNameRequest $request, Feature $feature)
    {
        $feature->setTranslation('name', 'ar', $request->name_ar);
        $feature->setTranslation('name', 'en', $request->name_en);
        $feature->save();
        return $this->apiResponse(
            data: FeatureResource::make($feature),
            message: __('messages.update_feature_name')
        );
    }
}
