<?php

namespace App\Http\Controllers\Api\Shipments;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\AssignShipmentToDeliveryRequest;
use App\Http\Requests\ShipmentRequest;
use App\Http\Requests\UpdateShipmentStatusRequest;
use App\Http\Resources\ShipmentResource;
use App\Http\Services\NotificationService;
use App\Http\Services\Shipments\ShipmentService;
use App\Mail\ShippmentStatusMail;
use App\Models\Shipment;
use App\Trait\ApiTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Mail;
class GetShipmentByStatusController extends Controller
{
    use ApiTrait;

    public function getPendingShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",1)->get()));
    }
    public function getAcceptedShipment()
    {
        $this->authorize('view accept_shipment');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",2)->get()));
    }
    public function getAssigenedShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",3)->get()));
    }
    public function getDeliveryShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",4)->get()));
    }
    public function getProcessingShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",5)->get()));
    }
    public function getDeliveredShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",6)->get()));
    }
    public function getCanceledShipment()
    {
        // $this->authorize('view shipments');
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('company_id', CompanyHelper::getId())->where("status",7)->get()));
    }

    
}
