<?php
namespace App\Http\Controllers\Api\Shipments;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\ShipmentItemTypeRequest;
use App\Http\Resources\ShipmentItemTypeResource;
use App\Http\Resources\ShipmentItemTypeDetailResource;
use App\Models\ShipmentItemType;
use App\Trait\ApiTrait;




class ShipmentItemTypeController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view shipment_item_types');
        return $this->apiResponse(data: ShipmentItemTypeResource::collection(ShipmentItemType::where('company_id', CompanyHelper::getId())->get()));
    }

    public function show($id)

    {
        $this->authorize('show shipment_item_types');
        return $this->apiResponse(data: ShipmentItemTypeDetailResource::make(ShipmentItemType::findOrFail($id)));
    }


    public function store(ShipmentItemTypeRequest $request)
    {
        $this->authorize('create shipment_item_types');
        return $this->apiResponse(data: ShipmentItemTypeResource::make(ShipmentItemType::create($request->validated())) , message:__('messages.shipment_item_type_created_successfully'));
    }

    public function update(ShipmentItemTypeRequest $request, $id)
    {
        $this->authorize('edit shipment_item_types');
        $shipmentItemType = ShipmentItemType::findOrFail($id);
        $shipmentItemType->update($request->validated());
        return $this->apiResponse(data: ShipmentItemTypeResource::make($shipmentItemType)  , message:__('messages.shipment_item_type_updated_successfully'));
    }

    public function destroy($id)
    {
        $this->authorize('delete shipment_item_types');

        $shipmentItemType = ShipmentItemType::findOrFail($id);
        $shipmentItemType->delete();
        return $this->apiResponse(message: __('messages.shipment_item_type_deleted_successfully'));
    }
}
