<?php

namespace App\Http\Controllers\Api\Shipments;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\ShipmentReceiverRequest;
use App\Http\Resources\ShipmentReceiverResource;
use App\Models\ShipmentReceiver;
use App\Trait\ApiTrait;

class ShipmentReceiverController extends Controller
{

    use ApiTrait;

    public function index()
    {
        $this->authorize('view shipment_receiver');

        return $this->apiResponse(data: ShipmentReceiverResource::collection(ShipmentReceiver::where('company_id', CompanyHelper::getId())->get()));
    }

    public function show($id)
    {
        $this->authorize('show shipment_receiver');
        $shipmentReceiver = ShipmentReceiver::where('company_id',  CompanyHelper::getId())->where('id', $id)->first();
        return $this->apiResponse(data: ShipmentReceiverResource::make($shipmentReceiver));
    }


    public function store(ShipmentReceiverRequest $request)
    {
        $this->authorize('create shipment_receiver');
        return $this->apiResponse(data: ShipmentReceiverResource::make(ShipmentReceiver::create($request->validated())), message: __('messages.shipment_receiver_created_successfully'));
    }

    public function update(ShipmentReceiverRequest $request, $id)
    {
        $this->authorize('edit shipment_receiver');
        $shipmentReceiver = ShipmentReceiver::where('client_id', $request->client_id)->where('company_id',  CompanyHelper::getId())->where('id', $id)->first();
        
        dd( $shipmentReceiver);
        $shipmentReceiver->update($request->validated());
        return $this->apiResponse(data: ShipmentReceiverResource::make($shipmentReceiver), message: __('messages.shipment_receiver_updated_successfully'));
    }

    public function destroy($id)
    {
        $this->authorize('delete shipment_receiver');
        $shipmentReceiver = ShipmentReceiver::where('company_id',  CompanyHelper::getId())->where('id', $id)->first();
        $shipmentReceiver->delete();
        return $this->apiResponse(message: __('messages.shipment_receiver_deleted_successfully'));
    }
}
