<?php

namespace App\Http\Controllers\Api\Supplier;

use App\Trait\ApiTrait;
use App\Models\BlockSupplier;
use App\Http\Controllers\Controller;
use App\Http\Enums\User\UserStatusEnum;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\BlockSupplierResource;
use App\Http\Requests\Api\Supplier\BlockSupplier\BlockSupplierRequest;
use App\Http\Requests\Api\Supplier\BlockSupplier\StoreBlockSupplierRequest;
use App\Http\Requests\Api\Supplier\BlockSupplier\UpdateBlockSupplierRequest;

class BlockSupplierController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view block suppliers');

        return $this->apiResponse(
            data: BlockSupplierResource::collection(CompanyHelper::getCompany(request())->blockSuppliers()->with(['supplier', 'blockReason'])->get())
        );
    }

    public function store(StoreBlockSupplierRequest $request)
    {
        $this->authorize('show block suppliers');

        $blockedSupplier = CompanyHelper::getCompany(request())->blockSuppliers()->create($request->validated());
        $blockedSupplier->supplier()->update(['status' => UserStatusEnum::BLOCKED->value]);

        return $this->apiResponse(
            data: BlockSupplierResource::make($blockedSupplier),
            message: __('messages.supplier_added_to_block_list_successfully')
        );
    }

    public function show(BlockSupplier $blockSupplier)
    {
        $this->authorize('create block suppliers');

        $blockSupplier->load(['supplier', 'blockReason']);

        return $this->apiResponse(
            data: BlockSupplierResource::make($blockSupplier),
        );
    }

    public function update(UpdateBlockSupplierRequest $request, BlockSupplier $blockSupplier)
    {
        $this->authorize('edit block suppliers');

        $blockSupplier->update($request->validated());

        return $this->apiResponse(
            data: BlockSupplierResource::make($blockSupplier),
            message: __('messages.supplier_in_block_list_data_updated_successfully')
        );
    }

    public function destroy(BlockSupplier $blockSupplier)
    {
        $this->authorize('delete block suppliers');

        $blockSupplier->supplier()->update(['status' => UserStatusEnum::INACTIVE->value]);
        $blockSupplier->delete();

        return $this->apiResponse(
            message: __('messages.supplier_removed_from_block_list_successfully')
        );
    }
}
