<?php

namespace App\Http\Controllers;

use App\Http\Helper\CompanyHelper;
use App\Http\Resources\CompanySystemSettingsResource;
use App\Http\Resources\SystemSettingsGroupResource;
use App\Models\CompanySystemSetting;
use App\Models\SystemSettingsGroup;
use Illuminate\Http\Request;

class CompanySettingsController extends Controller
{
    public function index()
    {


        $settingsData = CompanySystemSetting::where('company_id', CompanyHelper::getId())->with([
            'settings',
            'systemSettingGroup'
        ])->get();
        return $this->apiResponse(data: CompanySystemSettingsResource::collection($settingsData));
    }

    /**
     * Update the specified settings for the authenticated user's company.
     */
   public function updateSettings(Request $request,CompanySystemSetting $companySystemSetting)
    {

        $companySystemSetting->update([
            'value' => !$companySystemSetting->value,
            'content' => $request->content,
        ]);


        return $this->apiResponse(message: __('messages.setting_updated_successfully'));
    }
}

