<?php

namespace App\Http\Controllers\Online\V1;

use App\Models\Order;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Enums\Order\OrderStatusEnum;
use App\Http\Resources\OrderResource;
use App\Http\Requests\Online\V1\OrderRequest;
use App\Http\Services\Online\V1\Order\OrderService;

class OrderController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(data: [
            'orders' => OrderResource::collection(
                CompanyHelper::getCompany()->orders()->with('user.client:id,phone,name')->get()
            ),
            'statues' => OrderStatusEnum::getOrderStatuses()
        ]);
    }

    public function store(OrderRequest $request)
    {
        $reference_id = (new OrderService())->createOnlineOrder($request);

        return $this->apiResponse(message: __('messages.order_created_successfully'), data: ['reference_id' => $reference_id]);
    }

    public function show(Order $order)
    {
        $order->load(['user.client:id,name,phone', 'items.product:id,name,key']);
        return $this->apiResponse(data: OrderResource::make($order));
    }

    public function updateStatus(Order $order, string $status)
    {
        $order->update(['status' => OrderStatusEnum::getValueFromName($status)]);
        return $this->apiResponse(message: __('messages.order_updated_successfully'));
    }

    public function destroy(Order $order)
    {
        $order->delete();
        return $this->apiResponse(message: __('messages.order_deleted_successfully'));
    }
}
