<?php

namespace App\Http\Enums\Product;


enum ProductInventoryTypeEnum: int
{
    case INVENTORY_DAILY = 1;
    case INVENTORY_WEEKLY = 2;
    case INVENTORY_MONTHLY = 3;
    case INVENTORY_ANNUAL = 4;
    public static function getTypes(): array
    {
        return [
            self::INVENTORY_DAILY->value,
            self::INVENTORY_WEEKLY->value,
            self::INVENTORY_MONTHLY->value,
            self::INVENTORY_ANNUAL->value,
        ];
    }
    public static function getArabicTypes(): array
    {
        return [
            self::INVENTORY_DAILY->value => 'يومي',
            self::INVENTORY_WEEKLY->value => 'أسبوعي',
            self::INVENTORY_MONTHLY->value => 'شهري',
            self::INVENTORY_ANNUAL->value => 'سنوي',
        ];
    }
    public static function getValueFromArabicType(string $arabicType): int
    {
        return array_flip(self::getArabicTypes())[$arabicType];
    }
}
