<?php

namespace App\Http\Helper;

use App\Models\Company;
use App\Models\Feature;

class CompanyFeatureHelper
{
    public static function companyHasFeature(array $features): bool
    {
        $company = CompanyHelper::getCompany();

        $package = $company->companyCurrentPackageWithFeatures();

        foreach ($features as $feature) {
            $packageFeature = $package->features->where('key', $feature)->first();

            if (!$packageFeature || !self::checkFeatureIsNotValid($packageFeature, $company)) {
                return false;
            }
        }

        return count($features) > 0;
    }

    private static function checkFeatureIsNotValid(Feature $feature, Company $company): bool
    {
        $featureValue = $feature->pivot->value;

        return match ($feature->key) {
            Feature::FEATURE_WORKERS => $company->workers()->count() <  $featureValue,
            Feature::FEATURE_BRANCHES => $company->branches()->count() <  $featureValue,
            default => $featureValue == 1 || $featureValue == 'on'
        };
    }
}
