<?php

namespace App\Http\Helper;

use App\Models\Admin;
use App\Models\Company;
use Illuminate\Support\Str;
use Illuminate\Auth\AuthenticationException;

class CompanyHelper
{
    public static function getCompany($request = null)
    {
        $request = request();

        if (auth('company')->check()) {
            return auth('company')->user();
        }

        $company = $request->user()->company;


        if (!$company instanceof Company) {

            throw new AuthenticationException($request->user() instanceof Admin ? 'admin' : 'Unauthenticated');
        }

        return $company;
    }

    public static function createSecretKey()
    {
        $keyExists = true;
        $key = '';

        while ($keyExists) {
            $randomKey = Str::random(20);
            $formattedKey = implode('-', str_split($randomKey, 4));
            $key = $formattedKey;

            $keyExists = Company::where('secret_key', $key)->exists();
        }

        return $key;
    }

    public static function getId()
    {
        return self::getCompany()->id;
    }
}
