<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Feature;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyFeatureHelper;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpFoundation\Response;

class CheckCompanyHasFeature
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$feature): Response
    {
        if (!CompanyFeatureHelper::companyHasFeature($feature)) {
            throw ValidationException::withMessages(
                [
                    'package' => __('messages.invalid_feature')
                ]
            );
        }

        return $next($request);
    }
}
