<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Career;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class CompanyCareer
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (CompanyHelper::getId() !== $request->career->company_id || $request->career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        return $next($request);
    }
}
