<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Section;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class CompanySection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (CompanyHelper::getId() !== $request->section->company_id || $request->section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }
        return $next($request);
    }
}
