<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\AddressRepositoryInterface;
use App\Models\Address;

class AddressRepository implements AddressRepositoryInterface
{
    public function store($data)
    {
        return Address::create($data);
    }

    public function delete($id)
    {
        return Address::findOrFail($id)->delete();
    }

    public function update($address, $data)
    {
        $address->update($data);
    }
}
