<?php


namespace App\Http\Repositories;
use App\Http\Interfaces\AttendMethodRepositoryInterface;
use App\Models\AttendMethods;

class AttendMethodRepository implements AttendMethodRepositoryInterface
{
    public function all()
    {
        return AttendMethods::all();
    }
    public function activeMehtod()
    {
        return AttendMethods::where('status', 1)->pluck('id')->toArray();
    }

    public function with($relations)
    {
        return AttendMethods::with($relations)->get();
    }
    
    public function paginate($count)
    {
        return AttendMethods::with('attendDetails')->paginate($count);
    }

    public function store($data)
    {
        $data['name'] = [
            'ar' => $data['name_ar'],
            'en' => $data['name_en'],
        ];
        unset($data['name_ar']);
        unset($data['name_en']);

        return AttendMethods::create([
            'name' => $data['name'],
            'short_name' => $data['short_name'],
            'color' => $data['color'],
        ]);
    }

    public function setActive($data)
    {
        $methods = $data['methods'];

        if (!$methods) {
            return false;
        }

        foreach(AttendMethods::all() as $method) {
            if (in_array($method->id, $methods)) {
                $method->status = 1;
                $method->save();
            } else {
                $method->status = 0;
                $method->save();
            }
        }

    }

    public function destroy($id)
    {
        $method = AttendMethods::findOrFail($id);
        $method->attendDetails()->delete();
        $method->delete();
    }
}