<?php

namespace App\Http\Repositories;

use App\Models\Client;
use App\Http\Interfaces\ClientRepositoryInterface;

class ClientRepository implements ClientRepositoryInterface
{
    public function getAll()
    {
        return Client::where('company_id', auth()->id())
            ->whereNotIn('id', auth()->user()->blockClients->pluck('id'))->get();
    }

    public function show($client)
    {
        $client->load([
            'company',
            'address.area.city.country',
            'favoriteEmployee'
        ]);
        return $client;
    }

    public function create($data)
    {
        return Client::create($data);
    }

    public function update($data,  $client)
    {
        return $client->update($data);
    }

    public function addImage($client, $image)
    {
        $client = $client->update(['image' => $image]);
        return $client;
    }

    public function delete($client)
    {
        return $client->forceDelete();
    }
}
