<?php

namespace App\Http\Repositories;

use App\Models\Company;
use App\Http\Interfaces\CompanyRepositoryInterface;
use App\Trait\UploadFileTrait;

class CompanyRepository implements CompanyRepositoryInterface
{
    use UploadFileTrait;
    public function getAll()
    {
        $companies = Company::get();
        return $companies;
    }
    public function show(Company $company)
    {
        return $company;
    }
    public function create($data)
    {
        $logo = $this->uploadFile(Company::UPLOADED_FILES, $data['logo']);

        $company = Company::create(['logo' => $logo] + $data);
        return $company;
    }
    public function update($data, Company $company)
    {
        $company->update($data);
        return $company;
    }
    public function delete(Company $company)
    {
        $company->delete();
    }
}
