<?php

namespace App\Http\Repositories;
use App\Http\Interfaces\JobRepositoryInterface;
use App\Models\Job;
use App\Models\JobDepartment;

class JobRepository implements JobRepositoryInterface
{
    public function all()
    {
        return Job::all();
    }

    public function paginate($count)
    {
        return Job::with('jobDepartment')->paginate($count);
    }
    
    public function getJobs($id)
    {
        return Job::where('job_department_id', $id)->get();
    }

    public function store($data)
    {
        Job::create($data);
    }

    public function destroy($id)
    {
        return Job::findOrFail($id)->delete();

    }

    public function update($data, $id)
    {
        Job::findOrFail($id)->update($data);
    }
}