<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\WarehouseRepositoryInterface;
use App\Models\Warehouse;

class WarehouseRepository implements WarehouseRepositoryInterface
{

    public function index()
    {
        return Warehouse::with('type')->paginate();
    }

    public function store($data)
    {
        return Warehouse::create(['name' => json_encode($data['name'])] + $data);
    }

    public function update($warehouse, $data)
    {
        $warehouse->update($data);
    }

    public function delete($warehouse)
    {
        $warehouse->delete();
    }
}
