<?php

namespace App\Http\Requests\Admin\Setting;

use App\Http\Enums\Setting\SettingTypeEnum;
use Illuminate\Foundation\Http\FormRequest;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->route()->setting->type == SettingTypeEnum::STRING) {
            $valueRule = 'required|string';
        } elseif ($this->route()->setting->type == SettingTypeEnum::FILE) {
            $valueRule = 'required|file';
        }

        return [
            'value' => $valueRule,
        ];
    }
}
