<?php

namespace App\Http\Requests\Api\Admin\Unit;

use Illuminate\Foundation\Http\FormRequest;

class UnitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'nullable|array',
            'name_ar' => 'required|string',
            'name_en' => 'nullable|string',
            'category_id' =>'nullable'
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ]
        ]);
    }
}
