<?php

namespace App\Http\Requests\Api\AttendanceMethod;

use App\Models\AttendanceMethod;
use App\Rules\AttendanceDayRule;
use Illuminate\Foundation\Http\FormRequest;

class StoreAttendanceMethodRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(AttendanceMethod::RULES, [
            'days' => new AttendanceDayRule,
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ]
        ]);
    }
}
