<?php

namespace App\Http\Requests\Api\Company\Role;

use App\Http\Helper\CompanyHelper;
use App\Models\Company;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class AttachPermissionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Company::PERMISSIONS_RULES, [
            'all' => 'nullable|in:0,1'
        ]);
    }

    public function withValidator()
    {
        if ($this->role->company_id !== CompanyHelper::getId()) {
            throw ValidationException::withMessages(['role' => 'invalid role.']);
        }
    }
}
