<?php

namespace App\Http\Requests\Api\Company\ShipmentCompany;

use App\Models\ShipmentCompany;
use Illuminate\Foundation\Http\FormRequest;

class StoreShipmentCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return ShipmentCompany::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
        ]);
    }
}
