<?php

namespace App\Http\Requests\Api\Company\VacationRequest;

use App\Http\Helper\CompanyHelper;
use App\Models\VacationRequest;
use App\Rules\VacationRequestRule;
use Illuminate\Foundation\Http\FormRequest;

class StoreVacationRequestRequest extends FormRequest
{

    protected $stopOnFirstFailure = true;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => 'required|exists:employees,id',
            'from' => 'required|date',
            'to' => 'required|date',
            'reason' => 'required|string',
            'status' => 'required',
            'company_id' => 'required'
        ];
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => 'pending',
            'company_id' => CompanyHelper::getId(),
        ]);
    }
}
