<?php

namespace App\Http\Requests\Api\Company\Worker;

use App\Models\Worker;
use Illuminate\Foundation\Http\FormRequest;

class UpdateWorkerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Worker::RULES, [
            // 'employee_id' => [
            //     'required',
            //     'exists:employees,id,company_id,' . auth()->id(),
            //     'unique:workers,employee_id,' . $this->worker->employee_id
            // ],
            'role_id' => 'required|exists:roles,id,company_id,' . auth()->id(),
            'pos' => 'required|boolean'
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => $this->status == 'on',
            'has_shift' => $this->has_shift == 'on',
        ]);
    }
}
