<?php

namespace App\Http\Requests\Api\Employee\Auth;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Employee;
class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
           
        'name' => 'nullable',
        'name_ar' => 'required',
        'name_en' => 'nullable',
        'phone' => [
                'required',
                'string',
                'unique:employees,phone'
            ],
        'email' => [
                'required',
                'string',
                'unique:employees,phone'
            ],
            
        'code' => 'nullable',
        'branch_id' => 'required|exists:branches,id',
        'company_id' => 'required|exists:companies,id',
        ];
    }
    
    public function prepareForValidation()
    {
        $last_code = (int)(Employee::withTrashed()->latest()->first()->code ?? "200");
        $this->merge([
           
            'code' => (string) ($last_code + 1),
            // 'gender' => $this->gender == 1 ? 'male' : 'female',
            'name' => [
                'ar' =>  $this->name_ar,
                'en' => $this->name_en ,
            ],
        ]);
    }
}
