<?php

namespace App\Http\Requests\Api\Employee\Employee;

use App\Http\Helper\CompanyHelper;
use App\Models\Address;
use App\Models\Employee;
use App\Rules\ValidateArea;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreEmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Employee::RULES, Address::RULES, ['area_id' => ['nullable', 'exists:locations,id', new ValidateArea]], [
            'code' => 'required',
            'branches' => 'sometimes|array|min:1',
            'branches.*' => 'exists:branches,id',
            'phone' => [
                'required',
                'string',
                Rule::unique('employees')->where(function ($query) {
                    return $query->where('company_id', CompanyHelper::getId());
                }),
            ],
            'email' => [
                'nullable',
                'email',
                Rule::unique('employees')->where(function ($query) {
                    return $query->where('company_id', CompanyHelper::getId());
                }),
            ],
        ]);
    }

    public function prepareForValidation()
    {
        $last_code = Employee::withTrashed()->latest()->first()->code ?? 200;

        $this->merge([
            'code' => $last_code + 1,
            'status' => $this->status == 'on',
            'online' => $this->status == 'on',
            'calendar_appearance' => $this->status == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'address_line' => [
                'ar' => $this->address_line_ar,
                'en' => $this->address_line_en,
            ],
        ]);
    }
}
