<?php

namespace App\Http\Requests\Api\Employee\Transaction;

use App\Models\Employee;
use App\Models\EmployeeTransaction;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class StoreTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return EmployeeTransaction::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'temporary' => $this->temporary == 'on',
        ]);
    }

    public function passedValidation()
    {
        $employee = Employee::find($this->employee_id);
        if ($employee->branch_id != $this->from_branch_id) {
            throw ValidationException::withMessages([
                'employee_id' => [
                    'this employee does not belong to this branch.'
                ]
            ]);
        }
    }
}
