<?php

namespace App\Http\Requests\Api\Shift;

use App\Models\Shift;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class StoreShiftRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'branch_id' => 'required|exists:branches,id',
            'treasury_id' => 'required|exists:treasuries,id',
            'employee_id' => 'required|exists:employees,id',
            'start_amount' => 'required|numeric|min:0',
            'auto_shift_id' => 'nullable|exists:auto_shifts,id',
        ];
    }

    protected function passedValidation()
    {
        throw_if(
            Shift::where('employee_id', $this->employee_id)->whereNull('close_name')->exists(),
            ValidationException::withMessages(['auth' => [__('messages.employee_already_on_shift')]])
        );
    }
}
