<?php

namespace App\Http\Requests\Api\Shift;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class UpdateShiftRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'end_amount' => 'required|numeric|min:0',
        ];
    }

    protected function passedValidation()
    {
        throw_if(
            $this->route()->shift->close_name,
            ValidationException::withMessages(['auth' => [__('messages.shift_already_closed')]])
        );
    }
}
