<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CustodyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        $rules = [
            'status'   => 'required|boolean',
            'note' => 'required|string',
            'account_id' => 'required|exists:accounts,id',
            'company_Id' => 'required|exists:companies,id',
            'branch_id' => 'required|exists:branches,id',
            'employee_id' => [
                'required',
                Rule::exists('employees', 'id')->where('company_id', CompanyHelper::getId()),
            ],
        ];
        if ($this->has('_method') && $this->input('_method') !== 'put') {
            $rules['employee_id'][] = Rule::unique('custodies', 'employee_id');
        }

        return $rules;
    }

    public function prepareForValidation()
    {
        return $this->merge([
            'company_Id' => CompanyHelper::getId(),
        ]);
    }
}
