<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustodyTakenRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'account_id' => 'required|exists:accounts,id',
            'branch_id' => 'required|exists:branches,id',
            'employee_id' => 'required|exists:custodies,employee_id',
            'amount' => 'required|min:0|numeric ',
            'type' => 'required|string|in:withdraw,deposit',
        ];
    }
}
