<?php

namespace App\Http\Requests\Online\V1;

use Illuminate\Foundation\Http\FormRequest;

class OrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'bill_type' => 'required|in:sales',
            'note' => 'required|string',

            'transaction.amount.total' => 'required|numeric|min:0',
            'transaction.amount.subtotal' => 'required|numeric|min:0',
            'transaction.amount.tax' => 'required|numeric|min:0',
            'transaction.amount.discount' => 'required|numeric|min:0',
            'transaction.amount.paid_amount' => 'required|numeric|min:0',

            'transaction.sub_details.user_id' => 'required|string',
            'transaction.sub_details.cart_id' => 'required|string',

            'transaction.customer_details.name' => 'required|string',
            'transaction.customer_details.phone' => 'required|string',
            'transaction.customer_details.email' => 'required|string|email',
            'transaction.customer_details.country' => 'required|string',
            'transaction.customer_details.city' => 'required|string',
            'transaction.customer_details.address' => 'required|string',

            'transaction.item_list.*.key' => 'required|string',
            'transaction.item_list.*.name' => 'required|string',
            'transaction.item_list.*.quantity' => 'required|integer|min:0',
            'transaction.item_list.*.price' => 'required|numeric|min:0',
            'transaction.item_list.*.tax' => 'required|numeric|min:0',
            'transaction.item_list.*.discount' => 'required|numeric|min:.01',
        ];
    }
}
