<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class ShipmentItemTypeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' =>'array|nullable',
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'company_id' => 'required|exists:companies,id',
            'taxable' => 'required|boolean',
            'container_price' => 'required|numeric',
        ];
    }
    public function prepareForValidation()
    {
        return $this->merge([
            'name' => [
                'ar' => $this->name_ar ? $this->name_ar : $this->name_en,
                'en' => $this->name_en ? $this->name_en : $this->name_ar,
            ],
            'company_id' => CompanyHelper::getId(),
        ]);
    }
}
