<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreEmployeeInEmployeeTransferRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'previous_branch' => 'required',
            'employees' => 'required',
            'next_branch' => 'required|different:previous_branch',
            'temporary' => 'nullable',
            'end_date' => 'nullable'
        ];
    }
}
