<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class StoreEmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name_ar' => 'required|max:255',
            'name_en' => 'required|max:255',
            'code' => 'required|integer',
            'phone' => 'required|unique:employees,phone,company_id,' . CompanyHelper::getId(),
            'email' => 'required|unique:employees,email',
            'birth_date' => 'required|date',
            'id_type' => 'required|in:0, 1', // 0 =  passport .. 1 = national id
            'id_no' => 'required',
            'attend_method_id' => 'required',
            'Job_id' => 'required|exists:jobs,id',
            'hired_at' => 'required|date',
            'country_id' => 'required|exists:countries,id',
            'city_id' => 'required|exists:countries,id',
            'area_id' => 'required|exists:countries,id',
            'post_code' => 'required',
            'address_ar' => 'required|max:255',
            'address_en' => 'required|max:255',
            'status' => 'nullable',
            'appear_in_calendar' => 'nullable',
            'has_imprint' => 'nullable',
            'online_booking' => 'nullable',
        ];
    }
}
