<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class StoreInventoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'warehouse_id' => 'required|exists:warehouses,id',
            'company_id' => 'required|exists:companies,id',
            'date' => 'required|date',
            'status' => 'required|boolean',
            'description' => 'nullable|string',
            'products' => 'required|array|min:1',
            'products.*.id' => 'required|exists:products,id',
            'products.*.actual_quantity' => 'required|numeric|min:0',
            'products.*.diff_quantity' => 'required|numeric|min:0',
            'products.*.diff_quantity' => 'required|numeric',
        ];
    }
    public function prepareForValidation()
    {

        return $this->merge([
            'company_id' => CompanyHelper::getId(),
        ]);
    }
}
