<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class UpdateOpenBalanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array

    {
        $company = CompanyHelper::getCompany(request());
        return [
            'date' => 'required|date',
            'description' => 'nullable|string',
            'status' => 'required|in:draft,saved,accredited',



            'warehouse_id' => [
                'required',
                'exists:warehouses,id,company_id,' .  $company->id,
            ],
            'branch_id' => [
                'required',
                'exists:branches,id,company_id,' .  $company->id,
            ],
            'products' => 'required|array|min:1',
            'products.*.product_id' => 'required|exists:products,id,company_id,' .  $company->id,

            'products.*.unit_id' => [
                'required',
                'exists:company_units,id,company_id,' .  $company->id,
            ],
            'products.*.price' => 'required|numeric|min:1',
            'products.*.quantity' => 'required|numeric|min:1',
        ];
    }
}
