<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AccountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "key" => $this->code,
            "data" => [
                "id" => $this->id,
                "level_id" => $this->level_id,
                "name" => $this->name,
                'name_ar' => $this->getTranslations('name')['ar'] ?? '',
                'name_en' => $this->getTranslations('name')['en'] ?? '',
                "description" => $this->description,
                "description_ar" => $this->getTranslations('description')['ar'] ?? '',
                "description_en" => $this->getTranslations('description')['en'] ?? '',
                "parent_id" => $this->parent_id,
                "type" => $this->type,
                "status" => $this->status,
                "active" => $this->active,
                "amount" => number_format($this->amount, 2),
                'model' => $this->whenLoaded('model', function () {
                    return $this->model->first()?->name;
                }),
                "entries_amounts" => $this->whenLoaded('entriesAmounts', function () {
                    return [
                        'total_debit_amount' => $this->entriesAmounts?->first()?->total_debit_amount / 100,
                        'total_credit_amount' => $this->entriesAmounts?->first()?->total_credit_amount / 100,
                    ];
                }),
            ],
            "children" => AccountResource::collection($this->whenLoaded('children')),
            "entries" => EntryResource::collection($this->whenLoaded('entries')),
        ];
    }
}
