<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdvantageDetailResorce extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
         return [
            "id" => $this->id,
           "title_ar" => $this->getTranslation('title', 'ar'),
            "title_en" => $this->getTranslation('title', 'en'),
            "type" => $this->type,
            "content_ar" => $this->getTranslation('content', 'ar') ?? "",
            "content_en" =>$this->getTranslation('content', 'en') ?? "",
            "description_ar" => $this->getTranslation('description', 'ar') ?? "",
            "description_en" =>$this->getTranslation('description', 'en') ?? "",
            "image" => $this->image ? $this->image_path : "",
        ];
    }
}
