<?php

namespace App\Http\Resources;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AttendanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $carbonDate = Carbon::parse($this->start_date);
        return [
            "id" =>$this->id,
            "name" =>$this->employee->name ?? "",
            "branch" =>$this->branche->name?? "",
            "method" =>$this->method,
            "attendance_date" =>$this->start_date,
            "day" =>$carbonDate->format('l'),
            // "depture_date" =>$this->end_date,
            "attendance_time" =>$this->start_time ,
            "departure_time" =>$this->end_time,
            "over_time" =>$this->over_time,
            "image" =>$this->image ? $this->image: "",
               "employee" => $this->whenLoaded('employee'),
            ];
    }
}
