<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AutoShiftDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'amount' => $this->amount,
            'worker' => WorkerResource::make($this->whenLoaded('worker')),
            'auto_shift' => AutoShiftResource::make($this->whenLoaded('auto_shift')),
            'treasury' => TreasuryResource::make($this->whenLoaded('treasury')),
        ];
    }
}
