<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BlockClientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'client_id' => $this->client_id,
            'name' => $this->whenLoaded('client', function () {
                return $this->client->name;
            }),
            'block_reason' => BlockReasonResource::make($this->whenLoaded('blockReason')) ,
            'date' => $this->date,
            'note' => $this->note,
        ];
    }
}
